<?php
// --- MAIL DEBUGGER SETUP ---
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

$debug_log_file = __DIR__ . '/mail_debug_log.txt';

// --- Custom error + exception handlers ---
function mail_debug_error($errno, $errstr, $errfile, $errline) {
    global $debug_log_file;
    $msg = "[".date('Y-m-d H:i:s')."] ERROR $errno: $errstr in $errfile on line $errline\n";
    error_log($msg, 3, $debug_log_file);
    return false;
}
set_error_handler("mail_debug_error");

function mail_debug_exception($exception) {
    global $debug_log_file;
    $msg = "[".date('Y-m-d H:i:s')."] UNCAUGHT EXCEPTION: ".$exception->getMessage().
           " in ".$exception->getFile()." on line ".$exception->getLine()."\n";
    error_log($msg, 3, $debug_log_file);
}
set_exception_handler("mail_debug_exception");

// --- Helper function for logging ---
function mail_debug_log($msg) {
    global $debug_log_file;
    error_log("[".date('Y-m-d H:i:s')."] $msg\n", 3, $debug_log_file);
}
?>
